% ex5_62.m
% (S2) linear + tanh(x), p. 101
clear
N=100;
r=0.1;
a=0.9;
q=0.16;
b=0.5;
t=0:1:N;
kk=100;
varf=zeros(1,kk);
varp=zeros(1,kk);
% randn('state',0)
L=1  
for k=1:kk
x=zeros(1,N+1);
v=sqrt(r)*randn(1,N+1);
w=sqrt(q)*randn(1,N+1);
y=zeros(1,N+1);
u=zeros(1,N+1);
u=sin(2*pi*t/50);
x(1)=0;
% data generation
for i=1:N
x(i+1)= a*x(i) + b*u(i)+w(i);
y(i)=tanh(x(i)) + v(i);
end
%
% Iterated EKF
xep=zeros(1,N+1);  % prediction xe_{t/t-1}
xef=zeros(1,N+1);  % filtering  xe_{t/t}
Pep=zeros(1,N+1);  % covariance of prediction P_{t/t-1}
Pef=zeros(1,N+1);  % covariance of filtering P_{t/t}
Pep(1,1)=5;       % initial covariance of prediction
K=zeros(1,L);
for i=1:N+1
    eta0=xep(1,i);
    for j=1:L
H=1/cosh(eta0);
H=H*H;
K(j)=Pep(1,i)*H/(H*Pep(1,i)*H+r);       % kalman gain
    eta1=xep(1,i) + K(j)*(y(i)-tanh(eta0)-H*(xep(1,i)-eta0)); 
    eta0=eta1;
    end
    xef(1,i)=eta1;
Pef(1,i)=r*Pep(1,i)/(H*Pep(1,i)*H+r);  % covariance of filtering
Pep(1,i+1)=a*Pef(1,i)*a + q;   % covarinace of prediction
xep(1,i+1)=a*xef(1,i)+b*u(1,i);    % predicted estimate
end

xep=xep(1,1:N+1);
Pep=Pep(1,1:N+1);
ef=xef-x;
ep=xep-x;
varf(k)=var(ef);  % filtering error 
varp(k)=var(ep);
end
vvarf=mean(varf)
vvarp=mean(varp)

figure(1)
plot(t,x(1,1:N+1),'r',t,y(1,1:N+1),'gx-',t,xef(1,1:N+1),'bo-',...
    'LineWidth',1.5)
xlabel('Number of steps t')
title('Fig. 5.4a: Filtering')
axis([0,100,-6,6]);
grid
legend('True x_t','Observation y_t','Filtered estimate x_{t|t}')

figure(2)
plot(t,Pef(1,1:N+1),'b',t,Pep(1,1:N+1),'m','LineWidth',1.5)
xlabel('Number of steps t')
title('Fig. 5.4b: Variances of Filtering and Prediction')
axis([0,100,0,5]);
grid
legend('Filtering P_{t|t}',...
    'Prediction P_{t|t-1}')




